﻿///
/// ファイル属性クラスのヘッダファイル。
///

#if       !defined(INCLUDED_SZ_FILE_ATTRIBUTES)
#define            INCLUDED_SZ_FILE_ATTRIBUTES

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// Windows プラットフォームネイティブなファイル属性型。
/// </summary>
typedef u32 NativeFileAttributes;

/// <summary>
/// ファイルの属性を表すクラス。NativeFileAttributes のラッパー程度の機能しか持たない。
/// </summary>
class SZ_SPEC FileAttributes
{
public:

  /// <summary>
  /// 属性を 0 で初期化するデフォルトコンストラクタ。
  /// </summary>
  FileAttributes() : attributes(0) {}

  /// <summary>
  /// 属性を指定するコンストラクタ。
  /// </summary>
  explicit FileAttributes(NativeFileAttributes attr) : attributes(attr) {}
  
  /// <summary>
  /// ネイティブ属性への変換オペレータ。
  /// </summary>
  operator NativeFileAttributes () { return (0x00FFFFFF & attributes); }

  /// <summary>
  /// ネイティブ属性を取得するメソッド。
  /// </summary>
  NativeFileAttributes GetAttributes() const
  {
    return attributes;
  }

  /// <summary>
  /// ネイティブ属性を設定するメソッド。
  /// </summary>
  void SetAttributes(NativeFileAttributes attr)
  {
    attributes = attr;
  }

  /// <summary>
  /// ネイティブ属性にビットをセットするメソッド。
  /// </summary>
  void SetBits(NativeFileAttributes bit) { attributes |= bit; }

  /// <summary>
  /// ネイティブ属性のビットをクリアするメソッド。
  /// </summary>
  void Unset(NativeFileAttributes bit) { attributes &= ~bit; }

  /// <summary>
  /// ディレクトリ属性がセットされているかどうかを取得するメソッド。
  /// </summary>
  /// <returns>ディレクトリ属性がセットされていれば true、セットされていなければ false。</returns>
  bool IsDirectory() const { return 0 != (attributes & FILE_ATTRIBUTE_DIRECTORY); }

private:

  NativeFileAttributes attributes;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_FILE_ATTRIBUTES)
